<?php
/**
 * ranbron Theme Customizer
 *
 * @package ranbron
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function ranbron_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

}
add_action( 'customize_register', 'ranbron_customize_register' );

function ranbron_theme_customize_register( $wp_customize ) {

    $wp_customize->add_section( 'ranbron_theme_slider_options', array(
        'title'          => esc_html__( 'Slider Settings', 'ranbron' )
    ) );

    $wp_customize->add_setting( 'ranbron_theme_slider_count_setting', array(
        'default'        => '1',
        'sanitize_callback' => 'absint'
    ) );

    $wp_customize->add_control( 'ranbron_theme_slider_count', array(
        'label'      => esc_html__( 'Number of slides displaying at once', 'ranbron' ),
        'section'    => 'ranbron_theme_slider_options',
        'type'       => 'text',
        'settings'   => 'ranbron_theme_slider_count_setting'
    ) );

    $wp_customize->add_setting( 'ranbron_theme_slider_time_setting', array(
        'default'        => '5000',
        'sanitize_callback' => 'absint'
    ) );

    $wp_customize->add_control( 'ranbron_theme_slider_time', array(
        'label'      => esc_html__( 'Slider Time (in ms)', 'ranbron' ),
        'section'    => 'ranbron_theme_slider_options',
        'type'       => 'text',
        'settings'   => 'ranbron_theme_slider_time_setting'
    ) );

    $wp_customize->add_setting( 'ranbron_theme_slider_loop_setting', array(
        'default'        => 'true',
        'sanitize_callback' => 'esc_textarea'
    ) );

    $wp_customize->add_control( 'ranbron_theme_loop', array(
        'label'      => esc_html__( 'Loop Slider Content', 'ranbron' ),
        'section'    => 'ranbron_theme_slider_options',
        'type'     => 'radio',
        'choices'  => array(
            'true'  => 'yes',
            'false' => 'no',
        ),
        'settings'   => 'ranbron_theme_slider_loop_setting'
    ) );

}
add_action( 'customize_register', 'ranbron_theme_customize_register' );



/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function ranbron_customize_preview_js() {
	wp_enqueue_script( 'ranbron_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'ranbron_customize_preview_js' );
