<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package ranbron
 */

get_header(); ?>
<section class="error-404-area">
	<div class="thm-container text-center">
		<h2><?php esc_html_e('404', 'ranbron'); ?></h2>
		<h3><?php esc_html_e('Oops! That page can not be found.', 'ranbron'); ?></h3>
		<p><?php esc_html_e('Sorry, but the page you are looking for does not exist.', 'ranbron'); ?></p>
		<a href="<?php echo esc_url(home_url( '/' )); ?>"><?php esc_html_e('Go to home page.', 'ranbron'); ?></a>
	</div><!-- /.thm-container -->
</section><!-- /.error-404-area -->

<?php get_footer(); ?>
